﻿/*
Name:   UK date type detection plug-in
Author: Andy McMaster
Source: http://datatables.net/plug-ins/type-detection
*/

jQuery.fn.dataTableExt.aTypes.unshift(
    function (sData) {
        if (sData !== null && sData.match(/^(0[1-9]|[12][0-9]|3[01])\/(0[1-9]|1[012])\/(19|20|21)\d\d$/)) {
            return 'date-uk';
        }
        return null;
    }
);

/*
Name:   Date (dd/mm/YY) sorting plug-in
Author: Andy McMaster
Source: http://datatables.net/plug-ins/sorting
*/
jQuery.extend(jQuery.fn.dataTableExt.oSort, {
    "date-uk-pre": function (a) {
        var ukDatea = a.split('/');
        return (ukDatea[2] + ukDatea[1] + ukDatea[0]) * 1;
    },

    "date-uk-asc": function (a, b) {
        return ((a < b) ? -1 : ((a > b) ? 1 : 0));
    },

    "date-uk-desc": function (a, b) {
        return ((a < b) ? 1 : ((a > b) ? -1 : 0));
    }
});
